/*
 * Copyright (c) 1997 Adrian Sun (asun@zoology.washington.edu)
 * Copyright (c) 1990,1993 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 *
 * modified from main.c. this handles afp options.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */


#include <arpa/inet.h>
#include <ctype.h>
#include <grp.h>
#include <netdb.h>
#include <netinet/in.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <unistd.h>

#include <atalk/compat.h>
#include <atalk/errchk.h>
#include <atalk/fce_api.h>
#include <atalk/globals.h>
#include <atalk/logger.h>
#include <atalk/util.h>

#include "status.h"
#include "auth.h"
#include "dircache.h"

#define LENGTH 512

/*
 * Show version information about afpd.
 * Used by "afp -v".
 */
static void show_version( void )
{
	int num, i;

	printf( "afpd %s - Apple Filing Protocol (AFP) daemon of Netatalk\n\n", VERSION );

	puts( "This program is free software; you can redistribute it and/or modify it under" );
	puts( "the terms of the GNU General Public License as published by the Free Software" );
	puts( "Foundation; either version 2 of the License, or (at your option) any later" );
	puts( "version. Please see the file COPYING for further information and details.\n" );

	puts( "afpd has been compiled with support for these features:\n" );

	num = sizeof( afp_versions ) / sizeof( afp_versions[ 0 ] );
	printf( "          AFP versions:\t" );
	for ( i = 0; i < num; i++ ) {
		printf( "%d.%d ", afp_versions[ i ].av_number/10, afp_versions[ i ].av_number%10);
	}
	puts( "" );
	printf("        TCP/IP Support:\t");
	puts("Yes");

	printf("     AppleTalk Support:\t");
#ifdef NO_DDP
	puts("No");
#else
	puts("Yes");
#endif
	printf( "         CNID backends:\t" );
#ifdef CNID_BACKEND_DBD
	printf( "dbd " );
#endif
#ifdef CNID_BACKEND_LAST
	printf( "last " );
#endif
#ifdef CNID_BACKEND_MYSQL
	printf( "mysql " );
#endif
	puts( "" );
}

/*
 * Show extended version information about afpd and Netatalk.
 * Used by "afp -V".
 */
static void show_version_extended(void )
{
	show_version( );

	printf( "      Zeroconf support:\t" );
#if defined (HAVE_MDNS)
	puts( "mDNSResponder" );
#elif defined (HAVE_AVAHI)
	puts( "Avahi" );
#else
	puts( "No" );
#endif

	printf( "  TCP wrappers support:\t" );
#ifdef TCPWRAP
	puts( "Yes" );
#else
	puts( "No" );
#endif

	printf( "         Quota support:\t" );
#ifndef NO_QUOTA_SUPPORT
	puts( "Yes" );
#else
	puts( "No" );
#endif

	printf( "   Admin group support:\t" );
	puts( "Yes" );

	printf( "    Valid shell checks:\t" );
#ifndef DISABLE_SHELLCHECK
	puts( "Yes" );
#else
	puts( "No" );
#endif

	printf( "      cracklib support:\t" );
#ifdef USE_CRACKLIB
	puts( "Yes" );
#else
	puts( "No" );
#endif

	printf( "            EA support:\t" );
	puts( EA_MODULES );

	printf( "           ACL support:\t" );
#ifdef HAVE_ACLS
	puts( "Yes" );
#else
	puts( "No" );
#endif

	printf( "          LDAP support:\t" );
#ifdef HAVE_LDAP
	puts( "Yes" );
#else
	puts( "No" );
#endif

	printf( "         D-Bus support:\t" );
#ifdef HAVE_DBUS_GLIB
	puts( "Yes" );
#else
	puts( "No" );
#endif

	printf( "     Spotlight support:\t" );
#ifdef WITH_SPOTLIGHT
	puts( "Yes" );
#else
	puts( "No" );
#endif

	printf( "         DTrace probes:\t" );
#ifdef WITH_DTRACE
	puts( "Yes" );
#else
	puts( "No" );
#endif
}

/*
 * Display compiled-in default paths
 */
static void show_paths( void )
{
	printf( "              afp.conf:\t%s\n", _PATH_CONFDIR "afp.conf");
	printf( "           extmap.conf:\t%s\n", _PATH_CONFDIR "extmap.conf");
	printf( "       state directory:\t%s\n", _PATH_STATEDIR);
	printf( "    afp_signature.conf:\t%s\n", _PATH_STATEDIR "afp_signature.conf");
	printf( "      afp_voluuid.conf:\t%s\n", _PATH_STATEDIR "afp_voluuid.conf");
	printf( "       UAM search path:\t%s\n", _PATH_AFPDUAMPATH );
	printf( "  Server messages path:\t%s\n", SERVERTEXT);
}

/*
 * Display usage information about afpd.
 */
static void show_usage(void)
{
	fprintf( stderr, "Usage:\tafpd [-d] [-F configfile]\n");
	fprintf( stderr, "\tafpd -h|-v|-V\n");
}

void afp_options_parse_cmdline(AFPObj *obj, int ac, char **av)
{
    int c, err = 0;

    while (EOF != ( c = getopt( ac, av, "dF:vVh" )) ) {
        switch ( c ) {
        case 'd':
            obj->cmdlineflags |= OPTION_DEBUG;
            break;
        case 'F':
            obj->cmdlineconfigfile = strdup(optarg);
            break;
        case 'v':	/* version */
            show_version( ); puts( "" );
            show_paths( ); puts( "" );
            exit( 0 );
            break;
        case 'V':	/* extended version */
            show_version_extended( ); puts( "" );
            show_paths( ); puts( "" );
            exit( 0 );
            break;
        case 'h':	/* usage */
            show_usage();
            exit( 0 );
            break;
        default :
            err++;
        }
    }
    if ( err || optind != ac ) {
        show_usage();
        exit( 2 );
    }

    return;
}
