// run-pass
use std::mem;

const FOO: fn(u8) -> u8 = |v: u8| { v };

const BAR: [fn(&mut u32); 5] = [
    |_: &mut u32| {},
    |v: &mut u32| *v += 1,
    |v: &mut u32| *v += 2,
    |v: &mut u32| *v += 3,
    |v: &mut u32| *v += 4,
];
fn func_specific() -> fn() -> u32 {
    || return 42
}

fn generic<T>(_: T) -> fn() -> usize {
    || mem::size_of::<T>()
}

fn main() {
    // Items
    assert_eq!(func_specific()(), 42);
    let foo: fn(u8) -> u8 = |v: u8| { v };
    assert_eq!(foo(31), 31);
    // Constants