" Vim syntax file
" Language:    Arduino
" Maintainer:  Johannes Hoff <johannes@johanneshoff.com> (invalid)
" Last Change: 21 October 2021
" License:     VIM license (:help license, replace vim by arduino.vim)

" Syntax highlighting like in the Arduino IDE
" Automatically generated by the script available at
"    https://github.com/johshoff/arduino-vim-syntax
" Using keywords from <arduino>/build/shared/lib/keywords.txt
" From version: 1.8.16

" Thanks to Rik, Erik Nomitch, Adam Obeng, Graeme Cross and Niall Parker
" for helpful feedback!

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" Read the C syntax to start with
if version < 600
  so <sfile>:p:h/cpp.vim
else
  runtime! syntax/cpp.vim
endif

syn keyword arduinoConstant  BIN CHANGE DEC DEFAULT EXTERNAL FALLING HALF_PI HEX
syn keyword arduinoConstant  HIGH INPUT INPUT_PULLUP INTERNAL INTERNAL1V1
syn keyword arduinoConstant  INTERNAL2V56 LED_BUILTIN LED_BUILTIN_RX
syn keyword arduinoConstant  LED_BUILTIN_TX LOW LSBFIRST MSBFIRST OCT OUTPUT PI
syn keyword arduinoConstant  RISING TWO_PI

syn keyword arduinoFunc      analogRead analogReadResolution analogReference
syn keyword arduinoFunc      analogWrite analogWriteResolution attachInterrupt
syn keyword arduinoFunc      bit bitClear bitRead bitSet bitWrite delay
syn keyword arduinoFunc      delayMicroseconds detachInterrupt
syn keyword arduinoFunc      digitalPinToInterrupt digitalRead digitalWrite
syn keyword arduinoFunc      highByte interrupts lowByte micros millis
syn keyword arduinoFunc      noInterrupts noTone pinMode pulseIn pulseInLong
syn keyword arduinoFunc      shiftIn shiftOut tone yield

syn keyword arduinoMethod    available availableForWrite begin charAt compareTo
syn keyword arduinoMethod    concat end endsWith equals equalsIgnoreCase export
syn keyword arduinoMethod    final find findUntil flush getBytes indexOf
syn keyword arduinoMethod    lastIndexOf length loop override parseFloat
syn keyword arduinoMethod    parseInt peek print println read readBytes
syn keyword arduinoMethod    readBytesUntil readString readStringUntil replace
syn keyword arduinoMethod    setCharAt setTimeout setup startsWith Stream
syn keyword arduinoMethod    substring toCharArray toInt toLowerCase toUpperCase
syn keyword arduinoMethod    trim

syn keyword arduinoModule    Keyboard Mouse Serial Serial1 Serial2 Serial3
syn keyword arduinoModule    SerialUSB

syn keyword arduinoStdFunc   abs accept acos acosf asin asinf atan atan2 atan2f
syn keyword arduinoStdFunc   atanf cbrt cbrtf ceil ceilf click constrain
syn keyword arduinoStdFunc   copysign copysignf cos cosf cosh coshf degrees exp
syn keyword arduinoStdFunc   expf fabs fabsf fdim fdimf floor floorf fma fmaf
syn keyword arduinoStdFunc   fmax fmaxf fmin fminf fmod fmodf hypot hypotf
syn keyword arduinoStdFunc   isfinite isinf isnan isPressed ldexp ldexpf log
syn keyword arduinoStdFunc   log10 log10f logf lrint lrintf lround lroundf map
syn keyword arduinoStdFunc   max min move pow powf press radians random
syn keyword arduinoStdFunc   randomSeed release releaseAll round roundf signbit
syn keyword arduinoStdFunc   sin sinf sinh sinhf sq sqrt sqrtf tan tanf tanh
syn keyword arduinoStdFunc   tanhf trunc truncf

syn keyword arduinoType      _Bool _Complex _Imaginary array atomic_bool
syn keyword arduinoType      atomic_char atomic_int atomic_llong atomic_long
syn keyword arduinoType      atomic_schar atomic_short atomic_uchar atomic_uint
syn keyword arduinoType      atomic_ullong atomic_ulong atomic_ushort boolean
syn keyword arduinoType      byte char16_t char32_t complex NULL null PROGMEM
syn keyword arduinoType      String word

hi def link arduinoType Type
hi def link arduinoConstant Constant
hi def link arduinoStdFunc Function
hi def link arduinoFunc Function
hi def link arduinoMethod Function
hi def link arduinoModule Identifier
