// Copyright (C) 2015 André Bargull. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-array.prototype.pop
es6id: 22.1.3.16
description: >
  Array.prototype.pop.name is "pop".
info: |
  Array.prototype.pop ( )

  17 ECMAScript Standard Built-in Objects:
    Every built-in Function object, including constructors, that is not
    identified as an anonymous function has a name property whose value
    is a String.

    Unless otherwise specified, the name property of a built-in Function
    object, if it exists, has the attributes { [[Writable]]: false,
    [[Enumerable]]: false, [[Configurable]]: true }.
includes: [propertyHelper.js]
---*/

assert.sameValue(Array.prototype.pop.name, "pop");

verifyNotEnumerable(Array.prototype.pop, "name");
verifyNotWritable(Array.prototype.pop, "name");
verifyConfigurable(Array.prototype.pop, "name");

reportCompare(0, 0);
